 aR  d - w ,  mP9      h	 ox  -  nSystem-wide
    NAME CpTask

; This is cp.task.asm~text~
; This contains all the multi-tasking routines

$SAVE NOLIST
$INCLUDE (cp.constant.asm.inc~text~)
$RESTORE

DGROUP GROUP DATA
CGROUP GROUP CODE

    PUBLIC Reschedule, TimerInterrupt, InitMultiTasking
    PUBLIC CpSignal, CpWait, CpCreateProcess, CpDeleteProcess
    PUBLIC CpDelay, CpWhoAmI, CpSetPriority, CpCreateSemaphore
    PUBLIC CpDeleteSemaphore, IncTimedProcesses, DecTimedProcesses
    PUBLIC HeadOfProcessQ, ComputeTime, FreeMe
    PUBLIC osProcessQ, osSemaQ, osCurrentPid, bootTrace
    PUBLIC sysCounter, gpibJump, gpibOff, gpibSeg
    PUBLIC cardID, cardType

; djm - added
    PUBLIC busyStack
    EXTRN InitInterruptController: NEAR, InitInterruptHandlers: NEAR
    EXTRN InitDiagnostics: FAR
    PUBLIC OsFreeMemQ, OsAllocMemQ 
; djm - end

; djm - removed
;    EXTRN DoBoot:FAR
; djm - end

    EXTRN InitMemMgr:FAR, IntAllocate:FAR
    EXTRN OsInsertIntoQ:FAR, OsInitQcb:FAR, OsRemoveFromQ:FAR, OsNewQElement:FAR
    EXTRN CpFree:FAR, CpSystemTick:FAR
    EXTRN TellMessageWaiters: FAR
%IF (%systemType EQ 2) THEN (
    EXTRN Init87:FAR
) FI


; variables

DATA SEGMENT PUBLIC 'DATA'

dummyError        DW ?           ; dummy error code
busyStack         DB 300 DUP (?) ; stack for busy process
osProcessQ        QcbType <>     ; Q of all processes
osSemaQ           QcbType <>     ; Q of all semaphores
osCurrentPid      DW ?           ; THE currentPid
loopPid           DW ?           ; temporary process that just loops
bootTrace         DB ?           ; character of boot device
busyStackOff      DW ?
busyStackSeg      DW ?           ; address of busy stack start
sysCounter        DD ?           ; system counter
timedProcesses    DW ?           ; # processes waiting on time
gpibJump          DB ?           ; long jump instr.
gpibOff           DW ?           ; offset of current gpib driver
gpibSeg           DW ?           ; segment of current gpib driver
pFontTableOff     DW ?           ; pointer to font table
pFontTableSeg     DW ?           ; (Not used by Compass Central)
nextpidToSchedule DW ?           ; used by rescheduler
bubbleSemaphore   DW ?           ; used by systems with bubbles
cardID            DB ?           ; card number of this card (1, 2, ..., 7)
cardType          DB ?           ; card type of this card ("F", "C", "A")
OsFreeMemQ        QcbType <>     ; Free memory list
OsAllocMemQ       QcbType <>     ; Alocate memory list
; constants

loopPidConst EQU 1800h        ; temporary pid for booting
loopSSConst  EQU 1800h        ; temporary SS for booting lopping process
loopSPConst  EQU 0400h        ; initial SP for looping process

DATA ENDS
$EJ

FirstPcbSegment SEGMENT PARA 'DATA'


firstPcb PcbType <>           ; first pcb for busy process


FirstPcbSegment ENDS

$EJ
CODE SEGMENT PUBLIC 'CODE'
    ASSUME CS:CGROUP, DS:DGROUP

DataFrame DW Data             ; segment of data group
FakeLoadTable DB 25 DUP (0)   ; fake load table for processes


    EXTRN tickGranularity:WORD

;    FreeMe : PROCEDURE (sel)
;
;    This will free the block at sel:0.  The error
;    from CpFree is ignored.

sel EQU WORD PTR [BP+4]

FreeMe PROC NEAR
    PUSH BP
    MOV BP, SP
    PUSHF

    PUSH sel
    XOR AX, AX                 ; sel:0
    PUSH AX

    PUSH CS:DataFrame
    MOV AX, OFFSET dummyError  ; @dummyError
    PUSH AX

    STI
    CALL CpFree                ; should interrupts really be enabled ???

    POPF
    POP BP
    RET 2
FreeMe ENDP
PURGE sel

;    PopStart
;
;    These are the first instructions a new process will execute.
;    This runs the after the return of SwapTaskRoutines.

PopStart PROC FAR

    POP DS                     ; initialize DS
    POP ES                     ; initialize ES
    IRET
PopStart ENDP
$EJECT

;    HeadOfProcessQ
;
;    This will return in DS the first process in OsProcessQ
;    This changes DS and BX

HeadOfProcessQ PROC NEAR

    MOV DS, CS:DataFrame
    MOV BX, OFFSET OsProcessQ
    MOV DS, DS:[BX].headOfQ         ; pid := OsProcessQ.headOfQ

    RET
HeadOfProcessQ ENDP


;    DecTimedProcesses
;
;    This will decrement the variable timedProcesses.
;    This uses the registers ES AND BX

DecTimedProcesses PROC NEAR

    PUSH ES
    MOV ES, CS:DataFrame
    MOV BX, OFFSET timedProcesses
    DEC WORD PTR ES:[BX]
    POP ES

    RET
DecTimedProcesses ENDP


;    IncTimedProcesses
;
;    This will inccrement the variable timedProcesses.
;    This uses the registers ES AND BX

IncTimedProcesses PROC NEAR

    PUSH ES
    MOV ES, CS:DataFrame
    MOV BX, OFFSET timedProcesses
    INC WORD PTR ES:[BX]
    POP ES

    RET
IncTimedProcesses ENDP
$EJECT


;    SemaphoreExists: PROCEDURE (sid) BOOLEAN;
;        DCL sid SidType
;
;    This will indicate whether a semaphore exists by
;    checking its id code

sid EQU WORD PTR [BP+4]              ; first param

SemaphoreExists PROC NEAR
    PUSH BP
    MOV BP, SP

    MOV AL, TRUE
    MOV ES, sid
    CMP ES:scbIdCode, semaphoreIdCode ; RETURN (scb.idCode = semaphoreIdCode)
    JE  SemaExDone

    MOV AL, FALSE

SemaExDone:
    POP BP
    RET 2
SemaphoreExists ENDP
PURGE sid


;    ProcessExists: PROCEDURE (pid) BOOLEAN;
;        DCL pid PidType
;
;    This will indicate whether a process exists by
;    checking its id code

;pid EQU WORD PTR [BP+4]              ; first param

;ProcessExists PROC NEAR
;    PUSH BP
;    MOV BP, SP

;    MOV AL, TRUE
;    MOV ES, pid
;    CMP ES:pcbIdCode, processIdCode ; RETURN (pcb.idCode = processIdCode)
;    JE  ProcessExDone

;    MOV AL, FALSE

;ProcessExDone:
;    POP BP
;    RET 2
;ProcessExists ENDP
;PURGE pid
$EJECT

;    FirstWaitingProcess : PROCEDURE (sid) PidType;
;        DCL sid SidType;
;
;    This will return the pid of the first process which is
;    waiting on this semaphore.  Null will be returned if no
;    process is waiting

sid EQU WORD PTR [BP+6]             ; first param

; let DS be pid

FirstWaitingProcess PROC NEAR
    PUSH DS
    PUSH BP
    MOV BP, SP

    CALL HeadOfProcessQ             ; DS := OsProcessQ.headOfQ

    MOV ES, sid
    CMP ES:scbCount, 0              ; IF scb.count = 0 THEN RETURN (nullWord)
    MOV AX, nullWord
    JE FirstWaitReturnNull

    MOV DX, ES                      ; DX := sid to test for

    MOV AX, DS                      ; init AX
FirstWaitTopOfLoop:
    MOV DS, AX
    CMP AX, nullWord                ; DO WHILE pid <> nullWord;
    JE FirstWaitReturnNull

    MOV AL, DS:pcbState
    AND AL, timedMask
    CMP AL, semaphoreWait           ;    IF ((pcb.state AND timedMask) = semaphoreWait) 
    JNE FirstWaitNext

    CMP DS:pcbSource, DX            ;    AND (pcb.source = sid) THEN DO;
    JE FirstWaitFound               ;        RETURN (pid)

FirstWaitNext:
    MOV AX, DS:next                 ;    pid := pcb.next
    JMP SHORT FirstWaitTopOfLoop

FirstWaitFound:
    MOV AX, DS                      ;        RETURN (pid)

FirstWaitReturnNull:
                                    ; AX should already have null.
FirstWaitDone:   
    POP BP
    POP DS
    RET 2
FirstWaitingProcess ENDP
PURGE sid
$EJ
;    ComputeTime : PROCEDURE (time) WORD
;
;    This will return the number of ticks to wait

time EQU WORD PTR [BP+4]

ComputeTime PROC NEAR
    PUSH BP
    MOV BP, SP

    MOV AX, time
    MOV CX, CS:tickGranularity
    ADD AX, CX
    DEC AX              ; RETURN ((time + timeSlice - 1) / timeSlice)
    XOR DX, DX
    DIV CX

    POP BP
    RET 2
ComputeTime ENDP
PURGE time


;    CpWhoAmI : PROCEDURE PidType CLEAN
;
;    This will return the value of the current pid

CpWhoAmI PROC FAR
    PUSH DS

    MOV DS, CS:DataFrame
    MOV AX, DS:OsCurrentPid

    POP DS
    RET
CpWhoAmI ENDP
$EJ
;    AddToReadyQ : PROCEDURE (pid)
;
;    This will add a pcb to the process q.  It is added so
;    that it will be the last in the group of equal priority.

pid EQU WORD PTR [BP+6]

; let DS be tempPid
; let DX be prevPid
; let CL be pcb.priority

AddToReadyQ PROC NEAR
    PUSH DS
    PUSH BP
    MOV BP, SP

    MOV DS, pid
    MOV CL, DS:pcbPriority          ; CL := pcb.priority

    CALL HeadOfProcessQ             ; DS, tempPid := OsProcessQ.headOfQ

    MOV DX, nullWord                ; prevPid := nullWord

    MOV AX, DS
AddToTopOfLoop:
    MOV DS, AX
    CMP AX, nullWord                ; DO WHILE tempPid <> nullWord;
    JE AddToLoopExit

    CMP DS:pcbPriority, CL          ;     IF tempPcb.priority > pcb.priority THEN GOTO LoopExit
    JA AddToLoopExit

    MOV DX, DS                      ;     prevPid := tempPid;
    MOV AX, DS:next                 ;     tempPid := tempPcb.next
    JMP SHORT AddToTopOfLoop

AddToLoopExit:
    MOV AX, SEG OsProcessQ
    PUSH AX                         ; @OsProcessQ
    MOV AX, OFFSET OsProcessQ
    PUSH AX

    PUSH DX                         ; prevPid

    PUSH pid                        ; pid

    CALL OsInsertIntoQ

    POP BP
    POP DS
    RET 2
AddToReadyQ ENDP
PURGE pid
$EJ
;    FirstReadyProcess : PROCEDURE PidType
;
;    This will return the first process on the process
;    queue that is ready.

; let DS be pid

FirstReadyProcess PROC NEAR
    PUSH DS

    CALL HeadOfProcessQ             ; DS := OsProcessQ.headOfQ

    MOV AX, DS
FirstReadyTopOfLoop:
    MOV DS, AX
    CMP AX, nullWord                ; DO WHILE pid <> nullWord
    JE FirstReadyReturn

    CMP DS:pcbState, readyState     ;     IF pcb.state = readyState THEN RETURN (pid)
    JE FirstReadyReturn

    MOV AX, DS:next                 ;     pid := pcb.next
    JMP SHORT FirstReadyTopOfLoop

FirstReadyReturn:
    MOV AX, DS                      ; RETURN (pid)

    POP DS
    RET
FirstReadyProcess ENDP
$EJ
;    RoundRobinProcess : PROCEDURE (pid) PidType
;        DCL pid PidType
;
;    This will return the next round robin process
;    relative to the current pid.  It looks first at the
;    processes of equal priority and if none are ready then
;    then it takes the first ready process.

pid EQU WORD PTR [BP+6]

; let DS be pid
; let ES be FirstReadyProcess

RoundRobinProcess PROC NEAR
    PUSH DS
    PUSH BP
    MOV BP, SP

    CALL FirstReadyProcess
    MOV ES, AX                      ; ES = real first ready (this should never be null)

    MOV DS, pid                     ; DS := pid

    MOV DS, DS:next                 ; pid := pcb.next

    MOV AX, DS
RoundRobTopOfLoop:
    MOV DS, AX
    CMP AX, nullWord                ; DO WHILE pid <> nullWord (this should never be null)
    JE RoundRealFirst

    CMP DS:pcbState, readyState     ;     IF pcb.pcbState = readyState THEN EXIT
    JE RoundRobFirstReady

    MOV AX, DS:next                 ;     pid := pid.next
    JMP SHORT RoundRobTopOfLoop

RoundRobFirstReady:                 ; DS = curPid
    MOV AL, DS:pcbPriority
    CMP AL, ES:pcbPriority          ; IF curPcb.priority <= realPcb.priority THEN RETURN(curPid)
    MOV AX, DS
    JBE RoundRobReturn

RoundRealFirst:
    MOV AX, ES                      ; ELSE RETURN (real)

RoundRobReturn:
    POP BP
    POP DS
    RET 2
RoundRobinProcess ENDP
PURGE pid
$EJ
;    TellWaiters : PROCEDURE (sid)
;        DCL sid SidType
;
;    This will return an error to all those processes waiting
;    on a semaphore that has just been deleted.  Each of these
;    is put back into the ready state with an error of eSemaNotExist.

sid EQU WORD PTR [BP+6]
; let DS be curPid and DX be sid

TellWaiters PROC NEAR
    PUSH DS
    PUSH BP
    MOV BP, SP

    CALL HeadOfProcessQ             ; DS := OsProcess.headOfQ

    MOV DX, sid                     ; DX := sid

TellWaitTopOfLoop:
    MOV AX, DS
    CMP AX, nullWord                ; DO WHILE curPid <> nullWord
    JE TellWaitDone

    MOV AL, DS:pcbState
    MOV AH, AL                      ;     save state in AH
    AND AL, timedMask
    CMP AL, semaphoreWait           ;     IF ((curPcb.state AND timedMask) = semaphoreWait)
    JNE TellWaitNext
    CMP DS:pcbSource, DX            ;     AND (curPcb.source = sid) THEN DO;
    JNE TellWaitNext

    LES BX, DWORD PTR DS:pcbPErrorOff
    MOV WORD PTR ES:[BX], eSemaNotExist ;     error := eSemaNotExist

    CMP AH, timedSemaphoreWait      ;         IF curPcb.state = timedSemaphoreWait THEN DO;
    JNE TellWait10

    CALL DecTimedProcesses          ;             timedProcesses := timedProcesses - 1;

TellWait10:
    MOV DS:pcbState, readyState     ;         curPcb.state := readyState

TellWaitNext:
    MOV DS, DS:next                 ;     curPid := curPcb.next
    JMP SHORT TellWaitTopOfLoop

TellWaitDone:
    POP BP
    POP DS
    RET 2
TellWaiters ENDP
PURGE sid
$EJ
;    SwapTasksRoutine PROCEDURE
;
;    This is the actual code of the interrupt routine
;    This must be near and have no parameters

SwapTasksRoutine PROC NEAR
    PUSH BP
    MOV BP, SP

    MOV AX, OsCurrentPid           ; assume DS = CS:DataFrame
    MOV ES, AX                     ; ES := OsCurrentPid
    CMP AX, goodBye
    JE SwapTask10

    MOV ES:pcbStackSeg, SS
    MOV ES:pcbStackOff, SP         ; curPcp.stack = BUILDPTR(SS, SP)

    MOV AL, ES:pcbUses8087
    RCR AL, 1                      ; IF curPcb.uses8087 THEN
    JNB SwapTask10

%IF (%systemType EQ 2) THEN (
    PUSH DS
    LDS BX, ES:pcbP8087Regs
    PUSHF
    CLI
    FNSAVE DS:[BX]                 ;     CALL SaveRealStatus(@curPcb.the8087regs)
    WAIT
    POPF
    POP DS
) FI

SwapTask10:
    MOV AX, nextPidToSchedule
    MOV OsCurrentPid, AX           ; OsCurrentPid := nextpidToSchedule
    MOV ES, AX                     ; ES = OsCurrentPid

    MOV SS, ES:pcbStackSeg         ; STACKBASE := curPcb.stackSeg
    MOV SP, ES:pcbStackOff         ; STACKPTR := curPcb.stackOff

    MOV AL, ES:pcbUses8087
    RCR AL, 1                      ; IF curPcb.uses8087 THEN
    JNB SwapTask20

%IF (%systemType EQ 2) THEN (
    PUSH DS
    LDS BX, ES:pcbP8087Regs
    FRSTOR DS:[BX]                 ;     CALL RestoreRealStatus(@curPcb.the8087regs)
    WAIT
    POP DS
) FI

SwapTask20:
    POP BP
    RET
SwapTasksRoutine ENDP
$EJ
;    Reschedule : PROCEDURE (pid) CLEAN;
;
;    This will check for three things:
;
;    pid = roundRobin -> The next ready process in the current priority or lower
;          will be scheduled
;    pid = goodBye -> The current process is deleted, no state is saved.  The first
;          ready process is scheduled.
;    pid = other -> That process will be tested for higher priority.  If not higher
;          then no rescheduling occurs.

pid EQU WORD PTR [BP+8]

Reschedule PROC FAR
    PUSH DS
    MOV DS, CS:DataFrame
    PUSH BP
    MOV BP, SP

    CMP pid, roundRobin            ; IF pid = roundRobin THEN DO;
    JNE ReschTest2

    PUSH OsCurrentPid              ;    OsCurrentPid

    CALL RoundRobinProcess         ;    nextPidToSchedule := RoundRobinProcess(OsCurrentPid)
    JMP SHORT ReschDoIt

ReschTest2:
    CMP pid, goodBye               ; ELSE IF pid = goodBye THEN DO;
    JNE ReschTest3

    MOV OsCurrentPid, goodBye      ;     OsCurrentPid := goodBye

    CALL FirstReadyProcess         ;     nextPidToSchedule := FirstReadyProcess
    JMP SHORT ReschDoIt

ReschTest3:
    MOV ES, pid
    MOV AL, ES:pcbPriority
    MOV ES, OsCurrentPid           ; ELSE IF pcb.priority <= curPcb.priority THEN 
    CMP AL, ES:pcbPriority
    JA ReschDone

    MOV AX, pid

ReschDoIt:                         ; AX = nextPidToSchedule
    CMP AX, OsCurrentPid           ; IF nextPidToSchedule = OsCurrentPid THEN
    JE ReschDone                   ;     RETURN

    MOV nextPidToSchedule, AX      ; nextPidToSchedule := AX
    CALL SwapTasksRoutine          ; do the rescheduling

ReschDone:
    POP BP
    POP DS
    RET 2
Reschedule ENDP
PURGE pid
$EJ
;    CpSignal : PROCEDURE (sid, mode, note, pError) CLEAN
;        DCL sid SidType;
;        DCL mode BYTE;
;        DCL note WORD;
;        DCL pError PTR;
;
;    This will signal a semaphore.  If a process is waiting on it, then it will
;    be put into the ready state and given a 1 word note, and the semaphore stays
;    in the busy state.  If there are no processes waiting, then the sema is left
;    not busy and the next process to wait gets the signal.  Rescheduling will occur
;    only if a process is already waiting.

pError EQU DWORD PTR [BP+8]        ; fourth param
note EQU WORD PTR [BP+12]          ; third param
mode EQU BYTE PTR [BP+14]          ; second param
sid EQU WORD PTR [BP+16]           ; first param

CpSignal PROC FAR
    PUSH DS
    PUSH BP
    MOV BP, SP
    PUSHF

    CLI                            ; disable interrupts

    LDS BX, pError
    MOV WORD PTR DS:[BX], eOK      ; error := eOK

    PUSH sid
    CALL SemaphoreExists           ; IF SemaphoreExists(sid) THEN DO;
    RCR AL,1
    JNB CpSignalNotExist

CpSignalExists:
    PUSH sid
    CALL FirstWaitingProcess       ;     AX (pid) := FirstWaitingProcess
    CMP AX, nullWord               ;     IF pid = nullWord THEN DO;
    JNE CpSignalYes

    MOV AL, mode
    AND AL, snoozeSignalMask       ;         AL = mode AND snoozeSignalMask
    CMP AL, signalNormal           ;         IF mode = signalNormal THEN DO;
    JNE CpSignalDone

    MOV DS, sid
    MOV AX, note
    MOV DS:scbNote, AX             ;             scb.note := note

    MOV DS:scbBusy, signalled      ;             scb.signalled := signalled
    JMP SHORT CpSignalDone

CpSignalYes:                       ;     ELSE (AX = pid); let DS be pid
    MOV ES, sid                    ;         let ES = sid
    MOV DS, AX                     ;         DS := AX (pid)

    MOV SI, DS                     ;         firstPid := pid; let SI be firstPid

    MOV ES:scbBusy, DS             ;         scb.busy := pid

CpSignalTopOfLoop:
    MOV AX, DS                     ;         DO WHILE pid <> nullWord
    CMP AX, nullWord
    JE CpSignalReschedule

    MOV AX, note
    MOV DS:pcbNote, AX             ;             pcb.note := note

    CMP DS:pcbState, timedSemaphoreWait
    JNE CpSignal10                 ;             IF pcb.state = timedSemaphoreWait THEN

    CALL DecTimedProcesses         ;                 timedProcesses := timedProcesses - 1;

CpSignal10:
    MOV DS:pcbState, readyState    ;             pcb.state := readyState;

    DEC ES:scbCount                ;             scb.count := scb.count - 1

    MOV AL, mode
    AND AL, snoozeSignalMask       ;             AL = mode AND snoozeSignalMask
    CMP AL, signalNormal           ;             IF mode = normalSignal THEN GOTO DoReschedule
    JE CpSignalReschedule

PUSH SI
PUSH ES                            ;             save sid
    PUSH ES                        ;             push sid

    CALL FirstWaitingProcess
POP ES
POP SI                             ;             restore these
    MOV DS, AX                     ;             pid := FirstWaitingProcess(sid)
    JMP SHORT CpSignalTopOfLoop

CpSignalNotExist:
    LDS BX, pError                 ; ELSE error := eSemaNotExist
    MOV WORD PTR DS:[BX], eSemaNotExist
    JMP SHORT CpSignalDone

CpSignalReschedule:
    CMP mode, snoozeSignalMask     ;         IF (mode < snoozeSignalMask) THEN DO;
    JAE CpSignalDone

    PUSH SI
    CALL Reschedule                ;             Reschedule(firstPid)

CpSignalDone:
    POPF
    POP BP
    POP DS
    RET 10
CpSignal ENDP
PURGE pError, note, mode, sid
$EJ
;    CpWait : PROCEDURE (sid, timeLimit, pError) WORD CLEAN
;        DCL sid SidType;
;        DCL timeLimit WORD;
;        DCL pError PTR;
;
;    This will wait for a signal on a semaphore for a certain amount
;    of time.  If the semaphore is not busy, then the process can
;    continue right away.  If it is busy, then the process must wait.
;    Note: processes of equal priority will wait in their order on the
;    the process q, not in the order of their waits.

pError EQU DWORD PTR [BP+8]        ; third param
timeLimit EQU WORD PTR [BP+12]     ; second param
sid EQU WORD PTR [BP+14]           ; first param

CpWait PROC FAR
    PUSH DS
    PUSH BP
    MOV BP, SP
    PUSHF

    CLI                            ; DISABLE

    LDS BX, pError
    MOV WORD PTR DS:[BX], eOK      ; error := eOK

    PUSH sid
    CALL SemaphoreExists
    RCR AL, 1                      ; IF SemaphoreExists(sid) THEN DO;
    JNB CpWaitNotExist

CpWaitExists:
    MOV DS, sid
    CMP DS:scbBusy, signalled      ;     IF scb.busy THEN DO;
    JNE CpWaitNotSignalled

    CALL CpWhoAmI
    MOV ES:scbBusy, AX             ;         scb.busy := OsCurrentPid

    MOV AX, DS:scbNote             ;         RETURN (scb.note)
    JMP SHORT CpWaitDone

CpWaitNotSignalled:                ;     ELSE
    CMP timeLimit, 0               ;         IF timeLimit = 0 THEN DO;
    JNE CpWait10

    LDS BX, pError
    MOV WORD PTR DS:[BX], eTimeOut ;             error := eTimeOut

    XOR AX, AX                     ;             RETURN (0);
    JMP SHORT CpWaitDone

CpWait10:
    CALL CpWhoAmI
    MOV DS, AX                     ;         LET ds ^ current pcb

    MOV DS:pcbState, semaphoreWait ;         curPcb.state = semaphoreWait

    CMP timeLimit, nullWord        ;         IF timeLimit <> nullWord
    JE CpWaitForever

    MOV DS:pcbState, timedSemaphoreWait ;        curPcb.state = timedSemaphoreWait

    CALL IncTimedProcesses         ;             timedProcesses = timedProcesses + 1

    PUSH timeLimit
    CALL ComputeTime
    MOV DS:pcbTimeLimit, AX        ;         curPcb.timeLimit = ComputeTime(timeLimit)

CpWaitForever:
    LES BX, pError
    MOV DS:pcbPErrorSeg, ES        ;         curPcb.pError = pError
    MOV DS:pcbPErrorOff, BX

    MOV AX, sid
    MOV DS:pcbSource, AX           ;         curPcb.source = sid

    MOV ES, sid
    INC ES:scbCount                ;         scb.count = scb.count + 1

    MOV AX, roundRobin
    PUSH AX                        ;         roundRobin

    CALL Reschedule                ;         Reschedule

    MOV AX, DS:pcbNote             ;         RETURN (curPcb.note)
    JMP SHORT CpWaitDone

CpWaitNotExist:                    ; ELSE
    LDS BX, pError
    MOV WORD PTR DS:[BX], eSemaNotExist ;error = eSemaNotExist

    XOR AX, AX                     ;     RETURN (0)

CpWaitDone:
    POPF
    POP BP
    POP DS
    RET 8
CpWait ENDP
PURGE sid, timeLimit, pError
$EJ
;    CpCreateProcess : PROCEDURE (pid)
;        DCL pid PidType
;
;    This will add a pcb to the ready q.  It will initialize as
;    many fields as it can.

pid EQU WORD PTR [BP+8]

; let DS be pid

CpCreateProcess PROC FAR
    PUSH DS
    PUSH BP
    MOV BP, SP
    PUSHF

    CLI                            ; DISABLE

    MOV DS, pid                    ; DS := pid

    MOV  DS:pcbIdCode, processIdCode


;;; old method of message queue initialization

;    PUSH DS
;    MOV AX, pcbHeadOfQOffset       ; @pcb.headOfQ
;    PUSH AX

;    MOV AL, FALSE                  ; FALSE
;    PUSH AX

;    MOV AX, SIZE mcbType           ; SIZE(mcb)
;    PUSH AX

;    CALL OsInitQcb


;;; new method of message queue initialization

    XOR  AX, AX                    ; AX = 0
    MOV  DS:pcbMsgCount, AL        ; msgCount = 0

    DEC  AX                        ; AX = nullword
    MOV  DS:pcbMsgHeadSeg, AX      ; msgHeadSeg = nullPtrHigh
;   MOV  DS:pcbMsgHeadOff, nullPtrLow

    MOV  DS:pcbMsgTailSeg, DS
    MOV  DS:pcbMsgTailOff, pcbMsgOverlayOffset


    PUSH DS
    POP  ES
    LEA DI, DS:pcbHeap             ; ES:DI := @pcb.heap
    MOV CX, 16                     ; SIZE of heap
    MOV AL, 0
    CLD
    REP STOSB                      ; CALL SETB(0, @pcb.heap, SIZE(pcb.heap))

    MOV DS:pcbState, readyState    ; pcb.state = readyState

    LES BX, DWORD PTR DS:pcbStackOff
   
    MOV AX, OFFSET PopStart
    MOV ES:[BX].regKip, AX         ; regTable.kip = OFFSET(@PopStart)

    MOV ES:[BX].regFl, initialFlagState ; regTable.fl = initialFlagState

    PUSH DS
    CALL AddToReadyQ               ; Add this to OsProcessQ

    POPF
    POP BP
    POP DS
    RET 2
CpCreateProcess ENDP
PURGE pid
$EJ
;    CpDeleteProcess : PROCEDURE (pid, exitCode, pError) CLEAN
;        DCL pid PidType;
;        DCL pError PTR;
;
;    This will delete the given process.  This will tell any processes
;    waiting on messages from it.  It will also free up the pcb.  Rescheduling
;    will occur only if this process is deleting itself.

pError EQU DWORD PTR [BP+8]        ; second param
exitCode EQU WORD PTR [BP+12]          ; code from OsExit
pid EQU WORD PTR [BP+14]           ; first param

hariKari EQU BYTE PTR [BP-2]       ; 1 local

CpDeleteProcess PROC FAR
    PUSH DS
    MOV DS, CS:DataFrame
    PUSH BP
    MOV BP, SP
    SUB SP, 2                      ; 1 local
    PUSHF

    CLI                            ; DISABLE
   
    MOV AX, OsCurrentPid
    CMP AX, pid
    MOV AL, TRUE                   ; hariKari = (pid = OsCurrentPid)
    JE CpDelete10

    MOV AL, FALSE

CpDelete10:
    MOV hariKari, AL

    MOV DS, pid                    ;     let DS be pid

    MOV AL, DS:pcbState
    TEST AL, timedWait
    JZ CpDelete20                  ;     IF (pcb.state AND timedWait) <> 0 THEN 

    PUSH AX
    CALL DecTimedProcesses         ;         timedProcesses := timedProcesses - 1;
    POP AX

CpDelete20:
    AND AL, timedMask
    CMP AL, semaphoreWait          ;     IF (pcb.state AND timedMask) = semaphoreWait THEN
    JNE CpDelete30

    MOV ES, DS:pcbSource
    CMP ES:scbIdCode, semaphoreIdCode ;         IF scb.idCode = semaphoreIdCode THEN
    JNE CpDelete30

    DEC ES:scbCount                ;                scb.count = scb.count - 1;

CpDelete30:
    PUSH DS:pcbProcID              ;    procID

    PUSH exitCode                  ;    code

    CALL TellMessageWaiters

    INC  DS:pcbIdCode              ;    pcb.idCode = NOT (pcb.idCode)

    PUSH DS                        ;    @pcb

    CALL FreeMe

    PUSH CS:DataFrame
    MOV AX, OFFSET OsProcessQ      ;     @OsProcessQ
    PUSH AX

    PUSH pid                       ;     pid

    CALL OsRemoveFromQ

    CMP hariKari, TRUE
    JNE CpDelete40                 ;    IF hariKari THEN

    MOV AX, goodBye
    PUSH AX                        ;        goodbye

    CALL Reschedule

CpDelete40:
    LDS BX, pError
    MOV WORD PTR DS:[BX], eOK      ;     error = eOK

    POPF
    MOV SP, BP
    POP BP
    POP DS
    RET 8
CpDeleteProcess ENDP
PURGE pError, pid, hariKari, exitCode
$EJ
;    CpDelay : PROCEDURE (timeLimit) CLEAN
;        DCL timeLimit WORD;
;
;    This will delay the current process for timeLimit milleseconds.
;    Even if timeLimit is 0, rescheduling will occur.

timeLimit EQU WORD PTR [BP+8]

; let DS be OsCurrentPid

CpDelay PROC FAR
    PUSH DS
    PUSH BP
    MOV BP, SP
    PUSHF

    CLI                            ; DISABLE

    CMP timeLimit, 0
    JE CpDelayReschedule           ; IF timeLimit <> 0 THEN DO;

    CALL CpWhoAmI
    MOV DS, AX                     ;     DS := OsCurrentPid

    PUSH timeLimit
    CALL ComputeTime               ;     curPcb.timeLimit := ComputeTime(timeLImit)
    MOV DS:pcbTimeLimit, AX

    MOV DS:pcbState, timedWait     ;     curPcb.state := timedWait

    MOV AX, CS:DataFrame
    MOV DS:pcbPErrorSeg, AX
    MOV AX, OFFSET dummyError      ;     curPcb.pError := @dummyError
    MOV DS:pcbPErrorOff, AX

    CALL IncTimedProcesses         ;     timedProcesses = timedProcesses + 1

CpDelayReschedule:
    MOV AX, roundRobin
    PUSH AX                        ; roundRobin

    CALL Reschedule

    POPF
    POP BP
    POP DS
    RET 2
CpDelay ENDP
PURGE timeLimit
$EJ
;    CpSetPriority : PROCEDURE (pid, priority, pError) CLEAN;
;        DCL pid PidType;
;        DCL priority BYTE;
;        DCL pError PTR;
;
;    This will set the priority of the given process.
;    IF the process is ready, then rescheduling will occur.

pError EQU DWORD PTR [BP+8]        ; third param
priority EQU BYTE PTR [BP+12]      ; second param
pid EQU WORD PTR [BP+14]           ; first param

; let DS = pid

CpSetPriority PROC FAR
    PUSH DS
    PUSH BP
    MOV BP, SP
    PUSHF

    CLI                            ; DISABLE

    LDS BX, pError
    MOV WORD PTR DS:[BX], eOK      ; error = eOK

    MOV DS, pid                    ; DS := pid

    PUSH CS:DataFrame
    MOV AX, OFFSET OsProcessQ      ;     @OsProcessQ
    PUSH AX

    PUSH DS                        ;     pid

    CALL OsRemoveFromQ

    MOV AL, priority
    MOV DS:pcbPriority, AL         ;     pcb.priority := priority

    PUSH DS                        ;     pid

    CALL AddToReadyQ

    CALL FirstReadyProcess         ;     push first ready process
    PUSH AX

    CALL Reschedule

    POPF
    POP BP
    POP DS
    RET 8
CpSetPriority ENDP
PURGE pError, priority, pid
$EJ
;    CpCreateSemaphore : PROCEDURE (sid) CLEAN;
;        DCL sid SidType
;
;    This will add a semaphore to the semaphore queue
;    and initialize its fields

sid EQU WORD PTR [BP+8]

; let DS be sid

CpCreateSemaphore PROC FAR
    PUSH DS
    PUSH BP
    MOV BP, SP
    PUSHF

    CLI                            ; DISABLE

    MOV DS, sid                    ; DS = sid

    CALL CpWhoAmI
    MOV DS:scbParentPid, AX        ; scb.parentPid = OsCurrentPid

    XOR AX, AX
    MOV DS:scbBusy, AX             ; scb.busy = notSignalled

    MOV DS:scbNote, AX             ; scb.note = 0

    MOV DS:scbCount, AX            ; scb.count = 0

    MOV DS:scbIdCode, semaphoreIdCode

    PUSH CS:DataFrame
    MOV AX, OFFSET OsSemaQ         ; @OsSemaQ
    PUSH AX

    MOV AX, nullWord               ; add to front of q
    PUSH AX

    PUSH DS                        ; sid

    CALL OsInsertIntoQ

    POPF
    POP BP
    POP DS
    RET 2
CpCreateSemaphore ENDP
PURGE sid
$EJ
;    CpDeleteSemaphore : PROCEDURE (sid, pError) CLEAN
;        DCL sid SidType;
;        DCL pError PTR;
;
;    This will delete a semaphore.  Any processes waiting on the
;    semaphore will get a Semaphore not exist error.

pError EQU DWORD PTR [BP+8]        ; second param
sid EQU WORD PTR [BP+12]

; let DS be sid

CpDeleteSemaphore PROC FAR         
    PUSH DS
    PUSH BP
    MOV BP, SP
    PUSHF

    CLI                            ; DISABLE

    LDS BX, pError
    MOV WORD PTR DS:[BX], eOK      ; error = eOK

    MOV DS, sid                    ; DS = sid

    PUSH DS
    CALL SemaphoreExists           ; IF SemaphoreExists(sid) THEN DO;
    RCR AL, 1
    JNB CpDSNotExist

    PUSH DS                        ;     sid

    CALL TellWaiters

    PUSH CS:DataFrame
    MOV AX, OFFSET OsSemaQ         ;     @OsSemaQ
    PUSH AX

    PUSH DS                        ;     sid

    CALL OsRemoveFromQ

    INC DS:scbIdCode               ;     scb.idCode = NOT(scb.idCode)

    PUSH DS                        ;     @scb

    CALL FreeMe

    CALL FirstReadyProcess
    PUSH AX                        ;     push first ready process

    CALL Reschedule

    JMP SHORT CpDsDone

CpDsNotExist:
    LDS BX, pError
    MOV WORD PTR DS:[BX], eSemaNotExist ; error = eSemaNotExist

CpDsDone:
    POPF
    POP BP
    POP DS
    RET 6
CpDeleteSemaphore ENDP
PURGE sid, pError
$EJ
;    TimerInterrupt : PROCEDURE CLEAN
;
;    This is called for each tick of the clock.  It will
;    go through the process q and decrement the time left of
;    any processes waiting on time.  If the time left goes to zero,
;    then the process is put into the ready state with a timeout
;    error, and rescheduling will occur.

; let DS be pid
; let CX be count
; let SI be numTimedProcesses
; let DI be firstReadyPid

TimerInterrupt PROC FAR
    PUSH DS
    PUSH BP
    MOV BP, SP

    MOV DS, CS:DataFrame
    MOV SI, DS:timedProcesses       ; numTimedProcesses = timedProcesses

    MOV DI, nullWord                ; firstReadyPid = nullWord

    CALL HeadOfProcessQ             ; DS = OsProcessQ.headOfQ

    XOR CX, CX                      ; count = 0

    MOV AX, DS                      ; init AX
TimerTopOfLoop:
    MOV DS, AX
    CMP AX, nullWord                ; DO WHILE (pid <> nullWord)
    JE TimerDone
    CMP CX, SI                      ;     AND (count < numTimedProcesses);
    JAE TimerDone

    MOV AL, DS:pcbState
    MOV BL, AL
    CMP AL, timedWait               ;     IF pcb.state >= timedWait THEN DO;
    JB TimerNext

    MOV AX, DS:pcbTimeLimit
    CMP AX, 0                       ;         IF pcb.timeLimit = 0 THEN DO;
    JE TimerIsZero

TimerNotZero:                       ;         ELSE DO;
    DEC AX
    MOV DS:pcbTimeLimit, AX         ;             pcb.timeLimit := pcb.timeLimit - 1

TimerIncCount:
    INC CX                          ;         count := count + 1

TimerNext:
    MOV AX, DS:next                 ;     pid := pcb.next
    JMP TimerTopOfLoop

TimerIsZero:
    CMP BL, timedSemaphoreWait      ;             IF pcb.state = timedSemaphoreWait THEN DO;
    JNE TimerNotSema

    MOV ES, DS:pcbSource
    DEC ES:scbCount                 ;                 scb.count = scb.count - 1

TimerNotSema:
    MOV DS:pcbState, readyState     ;             pcb.state := readyState

    LES BX, DWORD PTR DS:pcbPErrorOff
    MOV WORD PTR ES:[BX], eTimeOut  ;             error := eTimeOut

    CALL DecTimedProcesses          ;             timedProcesses -= 1

    CMP DI, nullWord                ;             IF firstReadyPid = nullWord THEN
    JNE TimerIncCount

    MOV  DI, DS                     ;                firstReadyPid := pid
    JMP SHORT TimerIncCount

TimerDone:
    CMP DI, nullWord                ; IF firstReadyPid <> nullWord THEN 
    JE TimerReturn

    PUSH DI                         ; firstReadyPid
    CALL Reschedule

TimerReturn:
    POP BP
    POP DS
    RET
TimerInterrupt ENDP


;    LoopProc
;
;    This will just loop forever

LoopProc PROC FAR

LoopLoop:
    STI                     ; enable Interrupts
    JMP LoopLoop            ; loop again

LoopProc ENDP

$EJ
;    InitMultiTasking : PROCEDURE (pDoBoot) CLEAN
;       DCL pDoBoot PTR;
;
;    This will init all the multitasking junk
;
; djm - added:
;   parameter passed in which specifies DoBoot entrypoint
;   calls to InitInterruptController and InitInterruptHandler
; djm - end

pDoBootOff EQU WORD PTR [BP+8]
pDoBootSeg EQU WORD PTR [BP+10]

InitMultiTasking PROC FAR
    PUSH DS
    MOV DS, CS:DataFrame
    PUSH BP
    MOV  BP, SP

; djm - added
    CALL InitInterruptController

    CALL InitInterruptHandlers

    CALL InitDiagnostics
; djm - end

    PUSH DS
    MOV AX, OFFSET OsProcessQ       ; @OsProcessQ
    PUSH AX

    MOV AL, FALSE                   ; FALSE
    PUSH AX

    MOV AX, SIZE pcbType            ; size of a pcb
    PUSH AX

    CALL OsInitQcb

    PUSH DS
    MOV AX, OFFSET OsSemaQ          ; @OsSemaQ
    PUSH AX

    MOV AL, FALSE                   ; FALSE
    PUSH AX

    MOV AX, SIZE scbType            ; size of a scb
    PUSH AX

    CALL OsInitQcb

    CALL InitMemMgr

; create busy process

    MOV AX, SEG firstPcb
    MOV DS:OsCurrentPid, AX         ; OsCurrentPid := SELECTOROF(firstPcb)
    MOV ES, AX

    MOV BX, OFFSET busyStack
    ADD BX, SIZE busyStack
    SUB BX, SIZE RegTableType       ; pRegTable (DS:BX) := @busyStack(SIZE(busyStack) - SIZE(regTable))


; djm - changed
    MOV AX, pDoBootOff
    MOV DS:[BX].regIp, AX           ; regTable.ip = OFFSETOF(@DoBoot)

    MOV AX, pDoBootSeg
    MOV DS:[BX].regCs, AX           ; regTable.cs = SELECTOR(@DoBoot)
; djm - end

    MOV DS:[BX].regDs, DS           ; regTable.ds = SELECTOROF(@OsCurrentPid)

    MOV DS:[BX].regFl, initialFlagState

    MOV DS:busyStackOff, BX
    MOV DS:busyStackSeg, DS         ; save start of this stack

    MOV ES:pcbStackSeg, DS
    MOV ES:pcbStackOff, BX          ; curPcb.stack := @regTable
    MOV ES:pcbPriority, 254         ; curPcb.priority := 254
                                    ; should this be changed by O.S. to 255 ???

    PUSH ES                         ; OsCurrentPid

    CALL CpCreateProcess

; now create temporary looping process

    MOV AX, loopPidConst
    MOV DS:loopPid, AX              ; loopPid := loopPidConst
    MOV ES, AX
PUSH ES                             ; save this

    XOR DI, DI
    MOV CX, SIZE PcbType            ; set this pcb to zero
    MOV AL, 0
    CLD
    REP STOSB

    MOV BX, loopSPConst
    SUB BX, SIZE RegTableType       ; pRegTable (DS:BX) := @busyStack(SIZE(initialSP) - SIZE(regTable))

    MOV AX, loopSSConst
    MOV ES, AX                      ; ES:BX = pRegTable

    MOV ES:[BX].regIp, OFFSET LoopProc ; regTable.ip = OFFSETOF(@DoBoot)

    MOV ES:[BX].regCs, SEG LoopProc   ; regTable.cs = SELECTOR(@DoBoot)

    MOV ES:[BX].regDs, DS           ; regTable.ds = SELECTOROF(@OsCurrentPid)

    MOV ES:[BX].regFl, initialFlagState

POP ES                              ; restore ES
    MOV ES:pcbStackSeg, loopSSConst
    MOV ES:pcbStackOff, BX          ; curPcb.stack := @regTable
    MOV ES:pcbPriority, 255         ; curPcb.priority := 255

    PUSH ES                         ; OsCurrentPid

    CALL CpCreateProcess

; set pLoadTable of both processes to FakeLoadTable
; so they can be deleted

    MOV AX, SEG FakeLoadTable
    MOV BX, OFFSET FakeLoadTable

    MOV ES, DS:OsCurrentPid
    MOV WORD PTR ES:pcbPLoadTable, BX
    MOV WORD PTR ES:pcbPLoadTable+2, AX

    MOV ES, DS:loopPid
    MOV WORD PTR ES:pcbPLoadTable, BX
    MOV WORD PTR ES:pcbPLoadTable+2, AX

%IF (%systemType EQ 2) THEN (
    CALL Init87
) FI

    MOV AX, 1
    PUSH AX
    CALL CpSystemTick               ; CALL CpSystemTick(1)

    MOV AX, goodBye                 ; goodBye
    PUSH AX

    CALL Reschedule

;    POP BP
;    POP DS
;    RET
InitMultiTasking ENDP

PURGE pDoBootOff, pDoBootSeg

CODE ENDS

    END
